package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.PersonTask;
import gov.va.vinci.dart.biz.Task;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestTaskDAO  extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
		Assert.assertNull(DartObjectFactory.getInstance().getTaskDAO().findById(0));
	}

	@Test
	public void testSix() throws Exception {
		TaskDAO taskdao = DartObjectFactory.getInstance().getTaskDAO();
		
		Assert.assertNull(taskdao.findById(-1));
		
		List<Task> taskList = taskdao.listAll();
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.size() > 0);
		
		Task task = taskList.get(0);
		Assert.assertNotNull(task);
		Assert.assertTrue(task.getId() > 0);
		Assert.assertNotNull(task.getRequest());
		
		Task task2 = taskdao.findById(task.getId());
		Assert.assertNotNull(task2);
		Assert.assertEquals(task2, task);
	}

	@Test
	public void testSeven() throws Exception {
		TaskDAO taskdao = DartObjectFactory.getInstance().getTaskDAO();
		
		List<Task> taskList = taskdao.listAll();
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.size() > 0);
	}

	@Test
	public void testEight() throws Exception {
		TaskDAO taskdao = DartObjectFactory.getInstance().getTaskDAO();

		List<Task> taskList = taskdao.listByRequestId(1);
		
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.size() > 0);
	}

	@Test
	public void testNine() throws Exception {
		TaskDAO taskdao = DartObjectFactory.getInstance().getTaskDAO();

		List<Task> taskList = taskdao.listOpenByRequestId(1);
		
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.size() > 0);
	}

	@Test
	public void testTen() throws Exception {
		PersonTaskDAO persontaskdao = DartObjectFactory.getInstance().getPersonTaskDAO();
		
		List<PersonTask> taskList = persontaskdao.listAllPersonTasks();
		Assert.assertNotNull(taskList);
		Assert.assertTrue(taskList.size() > 0);
		
		int taskId = taskList.get(0).getId();
		Assert.assertTrue(taskId > 0);
		
		PersonTask pt = persontaskdao.findById(taskId);
		Assert.assertNotNull(pt);

		TaskDAO taskdao = DartObjectFactory.getInstance().getTaskDAO();
		
		Task task = taskdao.findById(1);
		
		Assert.assertNotNull(task);
		task.setDescription("123456");
		
		taskdao.save(task);
		
		Task task2 = taskdao.findById(1);
		
		Assert.assertNotNull(task2);
		Assert.assertEquals(task2.getDescription(), "123456");
		
		task2.setDescription("Testing 123");
		
		taskdao.save(task2);
		
		Task task3 = taskdao.findById(1);
		
		Assert.assertNotNull(task3);
		Assert.assertEquals(task3.getDescription(), "Testing 123");
	}
}
